<?php

// Desabilitar cache
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0, post-check=0, pre-check=0");
header("Pragma: no-cache");
header("Expires: 0");

// Definir o caminho para a raiz da instalação do Joomla
define('_JEXEC', 1);
define('JPATH_BASE', realpath(dirname(__FILE__) . '/..')); // Caminho para o diretório raiz do Joomla
require_once JPATH_BASE . '/includes/defines.php';
require_once JPATH_BASE . '/includes/framework.php';

use Joomla\CMS\Factory;

// Acessar o banco de dados usando a API do Joomla
$db = Factory::getDbo();

// ---------------------------------------------------------------------
// 1. Consulta os parâmetros do plugin plg_system_askmyadmin
// ---------------------------------------------------------------------
$query = $db->getQuery(true); // Reiniciar query!

$pluginName = 'plg_system_askmyadmin';
$query->select($db->quoteName('params'))
      ->from($db->quoteName('#__extensions'))
      ->where($db->quoteName('name') . ' = ' . $db->quote($pluginName));
$params = $db->setQuery($query)->loadResult();

// Função para obter a URL base do domínio
function getDomainBaseUrl(): string {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $host = $_SERVER['HTTP_HOST'];
    $path = dirname($_SERVER['SCRIPT_NAME']);
    return rtrim(str_replace('/painelgrc', '', $protocol . $host . $path), '/') . '/';
}

// Processar os parâmetros do plugin e construir a URL
$paramsArray = $params ? json_decode($params, true) : [];
$keyname = $paramsArray['keyname'] ?? '';
$keyvalue = $paramsArray['keyvalue'] ?? '';

$adminUrlBase = getDomainBaseUrl() . 'administrator/';
$adminUrl = (!empty($keyname) && !empty($keyvalue)) 
    ? $adminUrlBase . '?' . $keyname . '=' . $keyvalue 
    : $adminUrlBase;

// ---------------------------------------------------------------------
// 2. Atualizar conteúdo do módulo com id = 160
// ---------------------------------------------------------------------
$query = $db->getQuery(true); // Reiniciar query!

$content = '<hr />
<h2 style="text-align: center;">Dúvidas?</h2>
<h3 style="text-align: center;">Envie um e-mail para <a href="mailto:contato@portalgrc.com.br">contato@portalgrc.com.br</a>, ligue para <a href="tel:03237472647">(32) 3747-2647</a> ou no Whatsapp: <a href="https://wa.me/+553237472647" target="_blank" rel="noopener">(32) 3747-2647</a></h3>
<p><a href="http://portalgrc.com.br/" target="_blank" rel="noopener"><img src="images/logo_portalgrc.png" alt="Bn Design - Desenvolvimento de sites" width="151" height="68" style="vertical-align: middle; margin: 20px auto; display: block;" loading="lazy" data-path="local-images:/logo_fundo_transparente_cor.png" /></a></p>';

$query->update($db->quoteName('#__modules')) // corrigi também: o nome correto é `#__modules` se estiver atualizando módulos
      ->set($db->quoteName('content') . ' = ' . $db->quote($content))
      ->where($db->quoteName('id') . ' = 160');
$db->setQuery($query)->execute();

// Verificar se a procedure SPGetRelationsPath existe e criar se necessário
try {
    /**
     * Usar a conexão nativa mysqli para operações específicas
     * @var \mysqli $mySQLi
     */
    $mySQLi = $db->getConnection();

    // Verificar a existência da procedure
    $procedureExistsQuery = "SELECT ROUTINE_NAME 
                             FROM INFORMATION_SCHEMA.ROUTINES 
                             WHERE ROUTINE_SCHEMA = DATABASE() 
                             AND ROUTINE_TYPE = 'PROCEDURE' 
                             AND ROUTINE_NAME = 'SPGetRelationsPath'";
    
    $procedureExists = $db->setQuery($procedureExistsQuery)->loadResult();

    // Se a procedure não existir, criar
    if (!$procedureExists) {
        // Obter o usuário MySQL conectado
        $definer = $db->setQuery("SELECT USER();")->loadResult();

        // Escapar caracteres especiais no definer
        [$user, $host] = explode('@', $definer);
        $escapedDefiner = "`" . $user . "`@`" . $host . "`";

        // Criar a procedure
        if (method_exists($mySQLi, 'real_query')) {
            $procedure = <<<PROCEDURE
CREATE DEFINER=$escapedDefiner PROCEDURE SPGetRelationsPath(IN sid INT(20), OUT `returnPath` TEXT)
BEGIN
DECLARE parentSid INT DEFAULT 0;
DECLARE loopResult TEXT DEFAULT NULL;
DECLARE spResult TEXT DEFAULT NULL;
DECLARE spRow TEXT DEFAULT NULL;
DECLARE spParent INT;
DECLARE spDone INT;
DECLARE allParents CURSOR FOR SELECT pid FROM {$db->getPrefix()}sobipro_relations WHERE id = sid;
DECLARE CONTINUE HANDLER FOR NOT FOUND SET spDone = 1;
OPEN allParents;

getAllParents:
LOOP
FETCH allParents INTO spParent;
IF spDone = 1 THEN LEAVE getAllParents; END IF;
SET parentSid = spParent;
SET loopResult = NULL;

WHILE parentSid IS NOT NULL
DO
IF loopResult IS NOT NULL THEN 
SET loopResult = (SELECT CONCAT(loopResult, ',', parentSid)); 
ELSE 
SET loopResult = parentSid; 
END IF;
SET parentSid = (SELECT pid FROM {$db->getPrefix()}sobipro_relations WHERE id = parentSid ORDER BY position LIMIT 1);
END WHILE;

SET spRow = (SELECT GROUP_CONCAT('{ "id": "', id, '", "type": "', oType, '", "spParent": "', pid, '", "position": "', position, '" }')
FROM {$db->getPrefix()}sobipro_relations
WHERE FIND_IN_SET(id, loopResult));

SET spRow = (SELECT CONCAT(' "', spParent, '": [ ', spRow, ' ] '));
IF spResult IS NOT NULL THEN 
SET spResult = (SELECT CONCAT(spResult, ',', spRow)); 
ELSE 
SET spResult = spRow; 
END IF;

END LOOP;
CLOSE allParents;
SET returnPath = (SELECT CONCAT('json://{ ', spResult, ' }'));
END;
PROCEDURE;
            $mySQLi->multi_query($procedure);
        }
    }
} catch (\Exception $e) {
    error_log("Erro ao verificar ou criar a procedure: " . $e->getMessage());
}

?>

<html lang="pt-br">
	<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title>Painel de controle | Portal GRC</title>
	<meta name="robots" content="noindex,nofollow">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="description" content="Painel administrativo. Portal GRC - Desenvolvimento de sites para órgãos públicos (prefeituras, câmaras e outras autarquias)." />
	<meta name="keywords" content="Portal Grc, painel administrativo, órgãos públicos, prefeituars, câmaras, autarquias." />
	<meta name="author" content="portalgrc.com.br" />

	<link rel="icon" href="images/favicon.png" sizes="32x32" />
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,500,600,700,800,900" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;700;900&display=swap" rel="stylesheet">
	

	<!-- Bootstrap  -->
	<link rel="stylesheet" href="css/bootstrap.css">
	<!-- Theme style  -->
	<link rel="stylesheet" href="css/style.css">

	<!-- Modernizr JS -->
	<script src="js/modernizr-2.6.2.min.js"></script>
	<!-- FOR IE9 below -->
	<!--[if lt IE 9]>
	<script src="js/respond.min.js"></script>
	<![endif]-->

	</head>
	<body>
	<div class="fh5co-loader"></div>

	<aside id="fh5co-aside" role="sidebar" class="text-center" style="background-image: url(images/img_bg_1_gradient.jpg);">
	
		<div id="fh5co-logo">
            <a href ="https://portalgrc.com.br/" target="_blank"><img src="images/logo.png" title="Portal GRC"></a>
         </div>
	</aside>

	<div id="fh5co-main-content">
		<div class="dt js-dt">
			<div class="dtc js-dtc">

				<div class="row">
					<div class="col-md-12">
						<div class="row">
							<div class="col-lg-12">
								<div class="fh5co-intro">
									<h1>Painel de controle</h1>
									
								</div>
							<div class="alinhar-botoes">
								<a href="<?php echo htmlspecialchars($adminUrl, ENT_QUOTES, 'UTF-8'); ?>"> <button type="submit" title="Administrar site" class="btn-main"> <i class="fa-solid fa-sliders"></i> Administrar site </button> </a>
								<a href="https://portalgrc.com.br/tutoriais" target="_blank"> <button type="submit" title="Administrar site" class="btn-main2"><i class="fa-regular fa-circle-play"></i> Assistir vídeo aulas </button> </a>					
							</div>	
							
							<hr>

							</div>

							<div class="col-lg-12">

								<div class="cta-box">
									<p><i class="fa-solid fa-virus"></i> Atenção: fiquem atentos ao receber e-mails que solicitem atualizações de seus dados. Na maioria das vezes essas mensagens são um tipo de golpe virtual. Proteja seus dados e evite um ataque hacker! Não clique em links suspeitos.  <a href="https://www.google.com/search?q=Golpes+Virtuais+phishing&oq=Golpes+Virtuais+phishing&aqs=chrome..69i57j33i160.271j0j9&sourceid=chrome&ie=UTF-8" target="_blank"  title="Dicas para evitar ataques">Clique aqui e confira como essa fraude funciona.</a></p>
									<p><i class="fa-solid fa-circle-info"></i> Dicas para proteger seu dispositivo: a atualização do antivírus, dos programas e do seu sistema operacional são fundamentais para garantir uma proteção a longo prazo.</p>          
								</div>

							</div>

							<div class="col-lg-12">					


								 <hr>

								<div class="texto-rodape">
									Nada, em toda a criação, está oculto aos olhos de Deus. Tudo está descoberto e exposto diante dos olhos daquele a quem havemos de prestar contas. (Hebreus 4:13) | <b>Só Jesus Cristo Salva.</b>
								 </div>

								

							</div>						
							
						</div>
					</div>
				</div>

				

		<div id="social-footer">
			<div class="row">
				<div class="col-md-8">
					<ul id="fh5co-social">
						<a href ="https://portalgrc.com.br/" target="_blank"  title="Site Portal GRC"><i class="fa-solid fa-link"></i></a >           
         
							<a href="https://www.facebook.com/portalgrc" target="_blank" title="Facebook Portal GRC">
							   <i class="fa-brands fa-facebook"></i>
							</a>
							<a href="https://www.instagram.com/portalgrc/" target="_blank" title="Instagram Portal GRC">
							   <i class="fa-brands fa-instagram"></i>
							</a> 
							<a href="tel:03237472647" target="_blank" title="Telefone fixo">
							   <i class="fa-solid fa-phone"></i>
							</a>  		

							<a href="mailto:contato@portalgrc.com.br" target="_blank" title="E-mail - contato@portalgrc.com.br">
								<i class="fa-regular fa-envelope"></i>
							</a>
						
							<a href="https://wa.me/553237472647" target="_blank" title="Telefone e Whatsapp - (32) 3747-2647">
								<i class="fa-brands fa-whatsapp"></i> 
							</a> 
					</ul>
				</div>
				<div class="col-md-4 social-copyright">
					<p> Fonte da imagem: <a href="https://www.freepik.com/free-photo/close-up-male-hands-using-laptop-home_1025837.htm#page=2&query=computer&position=13&from_view=search&track=sph" target="_blank">Freepik</a></p>
				</div>
			</div>
		</div>
					
			</div>
		</div>


	
		
	</div>
	
	<!-- jQuery -->
	<script src="js/jquery.min.js"></script>
	<!-- jQuery Easing -->
	<script src="js/jquery.easing.1.3.js"></script>
	<!-- Bootstrap -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Waypoints -->
	<script src="js/jquery.waypoints.min.js"></script>

	<!-- Main -->
	<script src="js/main.js"></script>

	</body>
</html>